﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.BusinessManager;

public partial class DataExportBioLab : Page
{
    private UserAccountManager _currentUser;
    
    protected void Page_Load(object sender, EventArgs e)
    {
        _currentUser = (UserAccountManager)HttpContext.Current.User;

        // Check whether the user has EFR TEFSC COORDINATOR role
        if (_currentUser.GetRoles().Contains(4))
        {
            Response.ClearContent();
            Response.AddHeader("content-disposition", "attachment; filename=DataExport.xls");
            Response.ContentType = "application/vnd.ms-excel";
        }
        else
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }
    }

    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        //Some text values will mistakenly interpreted as numeric by Excel, such as postal codes and social security numbers
        //Such fields may loose their trailing zeros, such as zip code "00700" converts into number 700
        //Use the code below to explicitely convert affected columns into text format
        //Column numbers start with 0
        
        if (e.Row.RowType == DataControlRowType.DataRow) 
        {
            //MJ, 01/25/2011, Cells values are referenced by ColumnName instead of column Index
            GetCellsByBoundFieldName(e.Row, "SSN").ForEach(c => c.Attributes.Add("class", "text"));
            GetCellsByBoundFieldName(e.Row, "LAB_REF_RGE").ForEach( c => c.Attributes.Add("class", "text"));
            GetCellsByBoundFieldName(e.Row, "TEF_REF_RGE").ForEach( c => c.Attributes.Add("class", "text"));          
         }     
    }

    public override void VerifyRenderingInServerForm(Control control)
    {
    }

    List<DataControlFieldCell> GetCellsByBoundFieldName(GridViewRow row, string fieldName)
    {
       
        return row.Cells.Cast<DataControlFieldCell>().Where(s => s.ContainingField.HeaderText.EndsWith(fieldName)).ToList(); 
    }


    protected void SqlDataSource1_Selecting(object sender, SqlDataSourceCommandEventArgs e)
    {
        e.Command.CommandTimeout = Helpers.GetTimeoutValue();
    }

}
